Used in REST APIs heavily. 
JSON syntax is derived from JavaScript Object Notation syntax: a simple data interchange format
-   Data is in name/value pairs
-   Data is separated by commas
-   Curly braces hold objects
-   Square brackets hold arrays

In **JSON**, **_values_** must be one of the following data types:
-   **a string** - The string type is used for strings of text. It may contain Unicode characters.
-   **a number** - can be integer or number and have the same validation keywords
-   **an object** - Objects are the mapping type in JSON. They map “keys” to “values”. In JSON, the “keys” must always be strings. Each of these pairs is conventionally referred to as a “property”.
-   **an array** - Arrays are used for ordered elements. In JSON, each element in an array may be of a different type.
-   **a boolean** - only two special values are accepted: true and false. Note that values that _evaluate_ to true or false, such as 1 and 0, are not accepted by the schema.
-   **null** - only one acceptable value: null.

> Note: Unlike JavaScript, JSON values **CANNOT** be a function, a date or undefined.

> Note: A JSON value MUST be an object, array, number, or string, or one of the following three literal names: false null true

For JSON string values that are passthrough, need to convert object into string using json escaper tool/library (escape the json, then replace \r and \n with blank, then paste the string as passthrough string)
- [[HTTP]]: HyperText Transfer Protocol 
- HTML: HyperText Markup Language 
- REST: Representational State Transfer 
- URI: Uniform Resource Identifier 
- URL: Uniform Resource Locator (subset of URI) 
- URN: Uniform Resource Number (subset of URI)


